<?php
    date_default_timezone_set("Asia/Jakarta");

    $file       = "manage/feedback.json";
    $jsondata   = file_get_contents($file);
    $data       = json_decode($jsondata, true); 
    $no         = getMax($data);
    $userAgent  = $_SERVER['HTTP_USER_AGENT'];
    $ip         = $_SERVER['REMOTE_ADDR'];


    function countStatus($arg){
        global $data;
        $jar = $data;
        foreach($jar as $key => $value){
            $date = date("Y-m-d",(int)$value['date']);
            $now = date("Y-m-d"); 
            if($date < $now) {
                unset( $jar[ $key ] );  
            }        
        }
        // var_dump($jar);
        $count = isset(array_count_values(array_column($jar, 'event'))[$arg])?array_count_values(array_column($jar, 'event'))[$arg]:0;
        return $count;
    }
    
    function date_compare($arg1,$arg2){
        return (int)$arg1['date'] - (int)$arg2['date'];
        // return (int)$arg2['date'] - (int)$arg1['date'];
    }

    usort($data, 'date_compare');

    function statusName($arg){
        $status = ["TRIAL", "ACTIVE", "OFF"];
        return $status[$arg];
    }

    function eventName($arg){
        $status = ["TRIAL", "REGULAR", "BIRTHDAY", "WEDDING"];
        return $status[$arg];
    }

    function tanggal_indo($tanggal, $cetak_hari = false){
        $hari = array ( 1 =>    'Senin',
                    'Selasa',
                    'Rabu',
                    'Kamis',
                    'Jumat',
                    'Sabtu',
                    'Minggu'
                );
                
        $bulan = array (1 =>   'Januari',
                    'Februari',
                    'Maret',
                    'April',
                    'Mei',
                    'Juni',
                    'Juli',
                    'Agustus',
                    'September',
                    'Oktober',
                    'November',
                    'Desember'
                );
        $split 	  = explode('-', $tanggal);
        $tgl_indo = $split[2] . ' ' . $bulan[ (int)$split[1] ] . ' ' . $split[0];
        
        if ($cetak_hari) {
            $num = date('N', strtotime($tanggal));
            return $hari[$num] . ', ' . $tgl_indo;
        }
        return $tgl_indo;
    }

    function dateFormat($arg){
        return tanggal_indo(date("Y-m-d",(int)$arg),true);
    }

    function getMax($arr) {
        if(!empty($arr)){
            $jar    = array();
            foreach ($arr as $vals) {
                array_push($jar,$vals["id"]);
            }
            return max($jar);
        }else{
            return 0;
        }
        
    }
    
    if(isset($_POST['save']) && !empty($_SERVER['HTTP_REFERER'])){
        $t=time();
        $name       = isset($_POST['name'])?$_POST['name']:"";
        $email      = isset($_POST['email'])?$_POST['email']:"";
        $phone      = isset($_POST['phone'])?$_POST['phone']:"";
        $datetime   = isset($_POST['datetime'])?$_POST['datetime']:"";
        $comment    = isset($_POST['comment'])?$_POST['comment']:"";
        $no++;
       
        // Data array baru
        $data [] = array(
            'id'        => $no,
            'timestamp' => $t,
            'name'      => $name,
            'email'     => $email,
            'phone'     => $phone,
            'datetime'  => $datetime,
            'comment'   => $comment,
            'status'    => 0,
            'ip'        => $ip,
            'userAgent' => $userAgent
        );

        // Mengencode data menjadi json
        $jsonfile = json_encode($data, JSON_PRETTY_PRINT);
    
        // Menyimpan data ke dalam anggota.json
        $data = file_put_contents($file, $jsonfile);

        if(!$data){
            echo "ERROR!";
        }
    }

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>ONADO FEEDBACK / REVIEW</title>
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Popperjs -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.2/dist/umd/popper.min.js" crossorigin="anonymous"></script>
    <!-- Tempus Dominus JavaScript -->
    <script src="https://cdn.jsdelivr.net/gh/Eonasdan/tempus-dominus@master/dist/js/tempus-dominus.js" crossorigin="anonymous"></script>
    <!-- Tempus Dominus Styles -->
    <link href="https://cdn.jsdelivr.net/gh/Eonasdan/tempus-dominus@master/dist/css/tempus-dominus.css" rel="stylesheet" crossorigin="anonymous">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet"/>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" rel="stylesheet"/>
    <!-- MDB -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.0.0/mdb.min.css" rel="stylesheet"/>
    
    
    <style>
        @media (min-width: 34em) {
            .card-columns {
                -webkit-column-count:2;
                -moz-column-count:2;
                column-count:2;   
            }
        }
        .nowrap {
            white-space:nowrap;
        }
        .logo {
            max-width: 60%;
        }
    </style>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
     <![endif]-->
  </head>
  <body>
    <div class="container">
        
        <br> <br> <br> 
        <div class="card">
            <div class="card-header text-center">
                <h4>ONADO FEEDBACK / REVIEW</h4>
            </div>
            <div class="card-body ">
                <form class="form" method="post">
                    <div class="form-group text-center">
                    <img src="manage/img/logo.png" class="img-fluid mx-auto d-block logo" alt="Onado Cafe">
                        <hr>
                        <h3>Ayo berikan ulasanmu untuk kami!</h3>
                        <hr>
                    
                        <div class="justify-content-center">
                            <div class="col-lg-12">
                                <form method="post">
                                    <div class="form-outline mb-3 mt-3">
                                        <input type="text" class="form-control" id="name" placeholder="Masukan Nama" name="name" required autofocus>
                                        <label for="name" class="form-label">Nama</label>
                                    </div>
                                    <div class="form-outline mb-3 mt-3">
                                        <input type="email" class="form-control" id="email" placeholder="example@mail.com" name="email" required>
                                        <label for="email" class="form-label">Email</label>
                                    </div>
                                    <div class="form-outline mb-3 mt-3">
                                        <input type="text" class="form-control" id="phone" placeholder="+62" value="62" name="phone" required>
                                        <label for="phone" class="form-label">Nomor Telepon</label>
                                    </div>
                                    <div class='form-outline mb-3 mt-3' id='datetimepicker5' data-td-target-input='nearest' data-td-target-toggle='nearest'>
                                        <input id='datetimepicker5Input' name='datetime' type='text' class='form-control' data-td-target='#datetimepicker5' data-td-toggle='datetimepicker' required>
                                        <label for="datetimepicker5Input" class="form-label">Tanggal & Jam Kunjungan</label>
                                    </div>
                                    <div class="form-outline mb-3 mt-3">
                                        <textarea class="form-control" rows="5" id="comment" style="height: 100px" name="comment" placeholder="Ulasan Anda" required></textarea>
                                        <label for="comment" class="form-label">Ulasan/Kritik/Saran Anda</label>
                                    </div>
                                    
                                    <hr>
                                <div class="d-grid">
                                    <button type="submit" name="save" data-mdb-ripple-color="dark" class="btn btn-outline-primary btn-block">Submit</button> 
                                </div>
                                </form>
                                
                                <div class="d-grid pt-1">
                                    <a href="/" class="btn btn-outline-dark btn-block" data-mdb-ripple-color="dark">BACK</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
                
            </div>
            <div class="card-footer text-center">
                <footer> <small>&copy; <?php echo date("Y"); ?> <a href="https://adfazmedia.com">AdFazMedia.com</a> All Rights Reserved</small> | <span class="text-muted small ">Your IP <?php echo $ip?></span></footer> 
            </div>
        </div>
    </div>
        <!-- MDB -->
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.0.0/mdb.min.js"></script>
        <!-- Bootstrap -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
        <script type="text/javascript">
            // new tempusDominus.TempusDominus(document.getElementById('datetimepicker5'));
            const today = new Date();
            today.setDate(today.getDate()+1);
            new tempusDominus.TempusDominus(document.getElementById('datetimepicker5'), {
                restrictions: {
                    maxDate : today
               },
               localization: {
                   locale: "id"
               }
            });
        </script>

    </body>
</html>