<?php
    date_default_timezone_set("Asia/Jakarta");
    function statusName($arg){
        $status = ["TRIAL", "ACTIVE", "OFF"];
        return $status[$arg];
    }

    function eventName($arg){
        $status = ["TRIAL", "REGULAR", "BIRTHDAY", "WEDDING"];
        return $status[$arg];
    }

    function tanggal_indo($tanggal, $cetak_hari = false){
        $hari = array ( 1 =>    'Senin',
                    'Selasa',
                    'Rabu',
                    'Kamis',
                    'Jumat',
                    'Sabtu',
                    'Minggu'
                );
                
        $bulan = array (1 =>   'Januari',
                    'Februari',
                    'Maret',
                    'April',
                    'Mei',
                    'Juni',
                    'Juli',
                    'Agustus',
                    'September',
                    'Oktober',
                    'November',
                    'Desember'
                );
        $split 	  = explode('-', $tanggal);
        $tgl_indo = $split[2] . ' ' . $bulan[ (int)$split[1] ] . ' ' . $split[0];
        
        if ($cetak_hari) {
            $num = date('N', strtotime($tanggal));
            return $hari[$num] . ', ' . $tgl_indo;
        }
        return $tgl_indo;
    }

    function dateFormat($arg){
        return tanggal_indo(date("Y-m-d",(int)$arg),true);
    }
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>ONADO LIVE MUSIC SCHEDULE</title>

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" integrity="sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ" crossorigin="anonymous">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
     <![endif]-->
  </head>
  <body>
    <div class="container">
        <nav class="navbar navbar-expand-sm bg-dark navbar-dark fixed-top">
            <!-- Brand -->
            <a class="navbar-brand" href="?">ONADO FEEDBACK</a>
            
            <!-- Toggler/collapsibe Button -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#collapsibleNavbar">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="collapsibleNavbar">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="?">HOME</a>
                    </li>
                    <!--<li class="nav-item">-->
                    <!--    <a class="nav-link" href="?band">LIST BAND</a>-->
                    <!--</li>-->
                    <!--<li class="nav-item">-->
                    <!--    <a class="nav-link" href="?schedule">SCHEDULE</a>-->
                    <!--</li>-->

                    <!-- Dropdown -->
                    <!-- <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbardrop" data-toggle="dropdown">
                    SETTINGS
                    </a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" href="?settings=device">Device</a>
                        <a class="dropdown-item" href="?settings=camera">Camera</a>
                    </div>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="?log">LOG</a>
                    </li> -->
                </ul>
            </div>
        </nav>
        <br> <br> <br> 
        <?php
            
 //   ========== PAGE =========
    if(isset($_GET['band'])){
        // list band PAGE 
        require 'band.php';    
    }else if(isset($_GET['schedule'])){
        // schedule list 
        require 'schedule.php';
    }else if(isset($_GET['camera'])){
        // CAMERA PAGE 
        require 'camera.php';
    }else{
        // HOME PAGE 
        require 'home.php';
  
    }
        
    ?>
            <div class="card-footer">
                <footer> <small>&copy; <?php echo date("Y"); ?> adfazmedia.com All Rights Reserved</small> </footer> 
            </div>
        </div>
    </div>
    </body>
</html>