<?php
    date_default_timezone_set("Asia/Jakarta");
    $file       = "visitor.txt";
    $userAgent  = $_SERVER['HTTP_USER_AGENT'];
    $ip         = $_SERVER['REMOTE_ADDR'];
    $date       = date("d-m-Y H:i:s");
    $str        = $date." | ".$ip." | ". $userAgent."\n";
    file_put_contents($file, $str, FILE_APPEND | LOCK_EX);
    $count = substr_count(file_get_contents($file), "\n");
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>ONADO CAFE</title>

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" integrity="sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ" crossorigin="anonymous">
    
   <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-RHTW1XG5DL"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-RHTW1XG5DL');
    </script>
    
    
    <!-- STYLE -->
    <style>
        @media (min-width: 34em) {
            .card-columns {
                -webkit-column-count:2;
                -moz-column-count:2;
                column-count:2;   
            }
        }
        .nowrap {
            white-space:nowrap;
        }
        .logo {
            max-width: 60%;
        }
        .menu {
            max-width: 100%;
        }
    </style>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
     <![endif]-->
  </head>
  <body>
    <div class="container">
        <br> 
        <div class="card">
            <div class="card-header ">
                <h4 class="text-center">ONADO CAFE</h4>
            </div>
            <div class="card-body ">
                <form class="form" method="post">
                    <div class="form-group">
                        <img src="livemusic/manage/img/logo.png" class="img-fluid mx-auto d-block logo" alt="Onado Cafe">
                        <?php if(isset($_GET['menu'])){ 
                        require "menu.php";
                        }else if(isset($_GET['reservasi'])){ ?>
                        <hr>
                        <h3 class="text-center">T&C RESERVATION</h3>
                        <hr>
                        <ol>
                            <li>Minimal 4 Orang.</li>
                            <li>Dikenakan Biaya Order 50K per-Orang diluar Tax.</li>
                            <li>Pembayaran Minimal Jumlah Orang x Biaya Order, (Ex. Jika 10 Orang Min Paymentnya 500rb).</li>
                            <li>Total Pesanan dibawah Pembayaran Minimal akan dikenakan sesuai dengan Minimal Pembayaran.</li>
                            <li>Durasi Waktu Maksimal 2 Jam.</li>
                            <li>Tidak di perkenankan membawa makanan dan minuman dari luar. (kecuali Kue Ulang Tahun)</li>
                            <li>Tidak diperkenankan membawa minuman keras atau beralkohol. (akan dikenakan denda yang berlaku)</li>
                            <li>Kedatangan telat lewat dari 30 menit dari jam perjanjian reservasi akan tercancel otomatis.</li>
                            <li>Konfirmasi Reservasi minimal H-1.</li>
                            <li>Konfirmasi menu makan dilakukan H-1 Sebelum Acara.</li>
                            <li>Reservasi untuk Weekend (Jum'at - Minggu) Hanya berlaku dari jam 12.00 - 16.00</li>
                            <li>Reservasi yang melewati batas waktu yang di tentukan harus melakukan konfirmasi ulang dan repeat order.</li>
                        </ol>
                            <hr>
                            Untuk Keperluan Lainnya Bisa Langsung Menekan Tombol dibawah.
                            <hr>
                            <a href="http://bit.ly/reservasi-Onado" class="btn btn-outline-success btn-block">AGREE</a>
                            <a href="/" class="btn btn-outline-dark btn-block">BACK</a>
                       
                        <?php }else{ ?>
                        <hr>
                        <!-- <h3 class="text-center">@onado.cafe</h3> -->
                        <hr>
                        <div class="justify-content-center">
                            <a href="?menu" class="btn btn-outline-dark btn-block">MENU</a>
                            <a href="?reservasi" class="btn btn-outline-dark btn-block">RESERVATION</a>
                            <a href="livemusic" class="btn btn-outline-dark btn-block">LIVE MUSIC</a>
                            <a href="http://g.page/onado-cafe" class="btn btn-outline-dark btn-block">LOCATION</a>
                            <a href="feedback" class="btn btn-outline-dark btn-block">FEEDBACK / REVIEW</a>
                        </div>
                        <?php } ?>
                    </div>
                </form>
            </div>
            <div class="card-footer">
                <footer> <small>&copy; <?php echo date("Y"); ?>  <a href="https://adfazmedia.com">AdFazMedia.com</a> All Rights Reserved | Total Visitor : <?php echo $count;?></small> </footer> 
            </div>
        </div>
    </div>
    </body>
</html>