<?php
    date_default_timezone_set("Asia/Jakarta");

    $jsondata   = file_get_contents("manage/jadwal.json");
    $data       = json_decode($jsondata,true);    
    $jsondata   = file_get_contents("manage/data.json");
    $data1       = json_decode($jsondata,true);   

    function countStatus($arg){
        global $data;
        $jar = $data;
        foreach($jar as $key => $value){
            $date = date("Y-m-d",(int)$value['date']);
            $now = date("Y-m-d"); 
            if($date < $now) {
                unset( $jar[ $key ] );  
            }        
        }
        // var_dump($jar);
        $count = isset(array_count_values(array_column($jar, 'event'))[$arg])?array_count_values(array_column($jar, 'event'))[$arg]:0;
        return $count;
    }
    
    function date_compare($arg1,$arg2){
        return (int)$arg1['date'] - (int)$arg2['date'];
        // return (int)$arg2['date'] - (int)$arg1['date'];
    }

    usort($data, 'date_compare');

    function statusName($arg){
        $status = ["TRIAL", "ACTIVE", "OFF"];
        return $status[$arg];
    }

    function eventName($arg){
        $status = ["TRIAL", "REGULAR", "BIRTHDAY", "WEDDING"];
        return $status[$arg];
    }

    function tanggal_indo($tanggal, $cetak_hari = false){
        $hari = array ( 1 =>    'Senin',
                    'Selasa',
                    'Rabu',
                    'Kamis',
                    'Jumat',
                    'Sabtu',
                    'Minggu'
                );
                
        $bulan = array (1 =>   'Januari',
                    'Februari',
                    'Maret',
                    'April',
                    'Mei',
                    'Juni',
                    'Juli',
                    'Agustus',
                    'September',
                    'Oktober',
                    'November',
                    'Desember'
                );
        $split 	  = explode('-', $tanggal);
        $tgl_indo = $split[2] . ' ' . $bulan[ (int)$split[1] ] . ' ' . $split[0];
        
        if ($cetak_hari) {
            $num = date('N', strtotime($tanggal));
            return $hari[$num] . ', ' . $tgl_indo;
        }
        return $tgl_indo;
    }

    function dateFormat($arg){
        return tanggal_indo(date("Y-m-d",(int)$arg),true);
    }

    $team   = isset($_GET['team']);
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>ONADO LIVE MUSIC SCHEDULE</title>

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" integrity="sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ" crossorigin="anonymous">

    <style>
        @media (min-width: 34em) {
            .card-columns {
                -webkit-column-count:2;
                -moz-column-count:2;
                column-count:2;   
            }
        }
        .nowrap {
            white-space:nowrap;
        }
        .logo {
            max-width: 60%;
        }
    </style>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
     <![endif]-->
  </head>
  <body>
    <div class="container">
        
        <br> <br> <br> 
        <div class="card">
            <div class="card-header ">
                <h4 class="text-center">ONADO LIVE MUSIC SCHEDULE</h4>
            </div>
            <div class="card-body ">
                <form class="form" method="post">
                    <div class="form-group">
                    <img src="manage/img/logo.png" class="img-fluid mx-auto d-block logo" alt="Onado Cafe">
                    <?php if($team){?>
                        <div class="card-columns">
                            <div class="card bg-success" style="height: 8rem;">
                                <div class="card-body text-center">
                                    <p class="card-text font-weight-bolder text-white text-uppercase" style="font-size:25px">
                                        regular <br> <span style="font-size:35px"><?php echo countStatus(1);?></span>
                                    </p>
                                </div>
                            </div>
                            <div class="card bg-primary" style="height: 8rem;">
                                <div class="card-body text-center">
                                    <p class="card-text font-weight-bolder text-white text-uppercase" style="font-size:25px">
                                        trial <br> <span style="font-size:35px"><?php echo countStatus(0);?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php }?>
                        <hr>
                        <h3 class="text-center">UP COMING</h3>
                        <hr>
                        <div class="justify-content-center">
                            <div class="col-lg-12">
                                <div class="table-responsive nowrap">
                                    <table class="table table-striped" style="text-align: center;">
                                    <thead>
                                        <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Band Name</th>
                                        <?php if($team){?>
                                        <th scope="col">EVENT</th>
                                        <?php }?>
                                        <th scope="col">DATE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php $no=1;foreach($data as $value){
                                        $date = date("Y-m-d",(int)$value['date']);
                                        $now = date("Y-m-d"); 

                                        if($date >= $now) {
                                            foreach ($data1 as $key => $d) {
                                                if ($d['id'] == $value['bandId']) {
                                                    $nama       = $d['nama'];
                                                    $pic        = $d['pic'];
                                                    $keterangan = $d['keterangan'];
                                                    $kontak     = $d['kontak'];
                                                    $event      = eventName($value['event']);
                                                    $tanggal = dateFormat($value['date']);
                                                    echo "<tr>";
                                                    echo "<th scope='row'>$no</th>";
                                                    echo "<td style='text-align: left;''>".$nama."</td>";
                                                    if($team){
                                                        echo "<td>".$event."</td>";
                                                    }
                                                    // echo "<td>".$value["date"]."</td>";
                                                    echo "<td>".$tanggal."</td>";
                                                    echo "</tr>";
                                                    $no++;
                                                }
                                            }
                                            
                                        }        
                                    }
                                    ?>
                                    
                                    </tbody>
                                    </table>
                                </div>
                                <hr>
                                <a href="/" class="btn btn-outline-dark btn-block">BACK</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card-footer">
                <footer> <small>&copy; <?php echo date("Y"); ?> adfazmedia.com All Rights Reserved</small> </footer> 
            </div>
        </div>
    </div>
    </body>
</html>